%define name Star_CUPS_Driver
%define version 3.17.0
%define release 1

Name:		%{name}
Summary:	Star Micronics SP, TSP and Mobile model CUPS printer drivers.
Version:	%{version}
Release:	%{release}
License:	GPL
Group:		Hardware/Printing
Source:	http://www.star-m.jp/service/s_print/bin/%{name}-3.17.0.tar.gz
URL:		http://www.star-m.jp/service/s_print/starcupsdrv_linux86_yyyymmdd.htm
Vendor:		Star Micronics Co., Ltd.
Packager:	Sota Ito <sota.ito@star-m.jp>
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot

%description
The StarCUPSDrv package contains CUPS based printer drivers
for the following models:

SP700
TSP100
TSP100GT
TSP650II
TSP700II
TSP800II
POP10
MCP20
MCP21
MCP30
MCP31
MCL21
MCL32
SK1-211/221
SK1-211/221 Presenter
SK1-311/321
SK1-311 Presenter
SK1-41
SK1-41 Presenter
SK5-31 Presenter
TSP100IV
BSC10II


These drivers allow for printing from all applications that use the
standard printing path (CUPS).

After installing this package, go to http://localhost:631 (aka http://127.0.0.1:631)
or use your favorite CUPS print manager to add a new queue for your printer.

%prep
%setup

%build
make RPMBUILD=true

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT rpmbuild

%clean
rm -rf $RPM_BUILD_ROOT


%pre
LDCONFIGREQ=0
if [ ! -e /usr/lib64/libcups.so ]
then
    for libcups in $(ls /usr/lib64/libcups.so*)
    do
        if [ -x $libcups ]
        then
            LDCONFIGREQ=1
            ln -s $libcups /usr/lib64/libcups.so
            break
        fi
    done
fi
if [ ! -x /usr/lib64/libcups.so ]
then
    echo "required library libcups.so not available"
    exit 1
fi
if [ ! -e /usr/lib64/libcupsimage.so ]
then
    for libcupsimage in $(ls /usr/lib64/libcupsimage.so*)
    do
        if [ -x $libcupsimage ]
        then
            LDCONFIGREQ=1
            ln -s $libcupsimage /usr/lib64/libcupsimage.so
            break
        fi
    done
fi
if [ ! -x /usr/lib64/libcupsimage.so ]
then
    echo "required library libcupsimage.so not available"
    exit 1
fi
if [ "$LDCONFIGREQ" = "1" ]
then
    ldconfig
fi
exit 0



%post
if [ -x /etc/software/init.d/cups ]
then
    /etc/software/init.d/cups stop
    /etc/software/init.d/cups start
elif [ -x /etc/rc.d/init.d/cups ]
then
    /etc/rc.d/init.d/cups stop
    /etc/rc.d/init.d/cups start
elif [ -x /etc/init.d/cups ]
then
    /etc/init.d/cups stop
    /etc/init.d/cups start
elif [ -x /sbin/init.d/cups ]
then
    /sbin/init.d/cups stop
    /sbin/init.d/cups start
elif [ -x /etc/software/init.d/cupsys ]
then
    /etc/software/init.d/cupsys stop
    /etc/software/init.d/cupsys start
elif [ -x /etc/rc.d/init.d/cupsys ]
then
    /etc/rc.d/init.d/cupsys stop
    /etc/rc.d/init.d/cupsys start
elif [ -x /etc/init.d/cupsys ]
then
    /etc/init.d/cupsys stop
    /etc/init.d/cupsys start
elif [ -x /sbin/init.d/cupsys ]
then
    /sbin/init.d/cupsys stop
    /sbin/init.d/cupsys start
elif [ -x /bin/systemctl ]
then
    systemctl restart cups.service
else
    killall -HUP cupsd
fi
exit 0


%preun
for ppd in $(ls '/etc/cups/ppd')
do
    if grep "SP700\|TSP100\|TSP100GT\|TSP650\|TSP700II\|TSP800II\|POP10\|MCP20\|MCP21\|MCP31\|MCL21\|MCL32"  "/etc/cups/ppd/$ppd"; then exit 127; fi
done
exit 0

%files
%attr(755, root, root) /usr/lib/cups/filter/rastertostar
%attr(755, root, root) /usr/lib/cups/filter/rastertostarlm
%attr(755, root, root) /usr/lib/cups/filter/rastertostarm
%attr(755, root, root) %dir /usr/share/cups/model/star/
%attr(644, root, root) /usr/share/cups/model/star/sp712.ppd
%attr(644, root, root) /usr/share/cups/model/star/sp742.ppd
%attr(644, root, root) /usr/share/cups/model/star/sp717.ppd
%attr(644, root, root) /usr/share/cups/model/star/sp747.ppd
%attr(644, root, root) /usr/share/cups/model/star/tsp113.ppd
%attr(644, root, root) /usr/share/cups/model/star/tsp143.ppd
%attr(644, root, root) /usr/share/cups/model/star/tsp143gt.ppd
%attr(644, root, root) /usr/share/cups/model/star/tsp654.ppd
%attr(644, root, root) /usr/share/cups/model/star/tsp700II.ppd
%attr(644, root, root) /usr/share/cups/model/star/tsp800II.ppd
%attr(644, root, root) /usr/share/cups/model/star/pop10.ppd
%attr(644, root, root) /usr/share/cups/model/star/mcp30.ppd
%attr(644, root, root) /usr/share/cups/model/star/mcp31.ppd
%attr(644, root, root) /usr/share/cups/model/star/mcp20.ppd
%attr(644, root, root) /usr/share/cups/model/star/mcp21.ppd
%attr(644, root, root) /usr/share/cups/model/star/mcl21.ppd
%attr(644, root, root) /usr/share/cups/model/star/mcl32.ppd
%attr(644, root, root) /usr/share/cups/model/star/sk1-211_221.ppd
%attr(644, root, root) /usr/share/cups/model/star/sk1-211_221_presenter.ppd
%attr(644, root, root) /usr/share/cups/model/star/sk1-311_321.ppd
%attr(644, root, root) /usr/share/cups/model/star/sk1-311_presenter.ppd
%attr(644, root, root) /usr/share/cups/model/star/sk1-41.ppd
%attr(644, root, root) /usr/share/cups/model/star/sk1-41_presenter.ppd
%attr(644, root, root) /usr/share/cups/model/star/sk5-31_presenter.ppd
%attr(644, root, root) /usr/share/cups/model/star/bsc10ii.ppd

%changelog
* Mon May 19 2025 Sota Ito <sota.ito@star-m.jp>
- Version 3.17.0
- Added MCL21
- Supported halftoning option with MCL21, MCL32
- Supported ChromeOS (Linux development environment only)

* Mon Jun 24 2024 Sota Ito <sota.ito@star-m.jp>
- Version 3.16.0
- Added BSC10II
- The following Star Printers at End of Support.
  TSP113GT, TSP651

* Thu Feb 22 2024 Sota Ito <sota.ito@star-m.jp>
- Version 3.15.0
- Support Tear Off Cut with MCL32

* Fri Sep 8 2023 Yuichi Matsushita <yuichi.matsushita@star-m.jp>
- Version 3.14.0
- Added support the following printer models.
  TSP100IV SK, SK1-41, SK1-41 Presenter, SK5-31 Presenter.

* Tue May 30 2023 Yuichi Matsushita <yuichi.matsushita@star-m.jp>
- Version 3.13.1
- Fixed a bug : MCL32, Incorrect cut operation when using black mark paper or label paper.

* Fri Mar 31 2023 Yuichi Matsushita <yuichi.matsushita@star-m.jp>
- Version 3.13.0
- Added mC-Label3
- The following Star Printers at End of Support.
   FVP10

* Fri Oct 29 2021 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.12.0
- Added TSP100IV

* Wed Apr 22 2020 Tatsuki Yamamoto <tatsuki.yamamoto@star-m.jp>
- Version 3.11.0
- Added print density +4 (mC-Print3 Series)
- MCP31C and MCP31CB (mC-Print3 Series) are supported

* Mon Dec 9 2019 Tatsuki Yamamoto <tatsuki.yamamoto@star-m.jp>
- Version 3.10.0
- Added SK1 Printers

* Thu Jul 25 2019 Yuichi Matsushita <yuichi.matsushita@star-m.jp>
- Version 3.9.0
- Added MCP30 Printer (mC-Print3 Series)

* Mon Nov 5 2018 Yuichi Matsushita <yuichi.matsushita@star-m.jp>
- Version 3.8.0
- Added mC-Sound Function(MCP31)

* Fri Jun 15 2018 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.7.0
- Added POP10, MCP31, MCP21 and MCP20
- The following Star Printers at End of Support.
   SP500, TSP650, TSP828L, TSP1000, TUP500, TUP900, HSP7000

* Tue Jun 7 2016 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.6.0
- Added TSP100III

* Thu Jan 15 2015 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.5.0
- Added 1500mm paper length .

* Mon Feb 3 2014 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.4.2
- Fixed bug that cannot print by using cupsfilter command.

* Tue Jan 28 2014 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.4.1
- Bug fix.
  Fixed bug that it may cause extremely slow printing or data lost when using CUPS drivers
  V3.4.0 or older with Mac OS X 10.9 (Mavericks).

* Fri Dec 14 2012 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.4.0 release
- Added TSP650II
- Modified File Permission (Mac OS X)

* Fri Feb 25 2011 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.2.1 release
- Added "cupsSNMPSupplies is False" in PPD file.

* Tue Aug 31 2010 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.2.0 release
- Added dataTreatmentRecoverFromError Function of TSP700II, TSP600 and SP700

* Tue Apr 20 2010 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.1.1 release
- Added FVP10

* Fri Feb 19 2010 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.0.2 release
- Added Tips.(TSP100IIU BackFeed script and Vertical Compression script)

* Tue Jun 30 2009 Yusuke Hara <yusuke.hara@star-m.jp>
- Version 3.1.0 release
- Added TSP800II

* Wed Oct 15 2008 Kazumasa Hosozawa <k-hoso@star-m.jp>
- Version 3.0.0 release
- Added TUP500

* Sun Mar 23 2008 Kazumasa Hosozawa <k-hoso@star-m.jp>
- Version 2.10.0 release
- Added HSP7000

* Wed Dec 12 2007 Kazumasa Hosozawa <k-hoso@star-m.jp>
- Version 2.9.0 release
- Added TSP100GT

* Mon Dec 3 2007 Kazumasa Hosozawa <k-hoso@star-m.jp>
- Version 2.8.2 release
- Bug fix. Dot-Printer's Print Speed.(SP700, SP500)

* Sun Sep 9 2007 Kazumasa Hosozawa <k-hoso@star-m.jp>
- Version 2.8.1 release
- Modified File Permission (Mac OS X)

* Tue Jun 26 2007 Kazumasa Hosozawa <k-hoso@star-m.jp>
- Version 2.8.0 release
- Added TSP650

* Thu Feb 8 2007 Toshiharu Takada <takada@star-m.jp>
- Version 2.7.0 release
- Added TSP700II

* Fri Dec 1 2006 Toshiharu Takada <takada@star-m.jp>
- Version 2.6.0 release
- Added SP700

* Fri Feb 24 2006 Kenichi Nagai <nagai@star-m.jp>
- Version 2.4.0 release
- Added TSP828L

* Fri Aug 19 2005 Dwayne Harris
- Version 2.3.0 release
- Added TSP100

* Mon Feb 14 2005 Albert Kennis
- Version 2.2.0 release
- Fixed bug - cash drawer setting not working

* Tue Oct 19 2004 Albert Kennis
- Version 2.1.0 release
- Added TSP1000
- Added USB device ID support to PPD files
- Fixed bug in support of custom page sizes

* Fri Jul 16 2004 Albert Kennis
- Version 2.0.0 initial release
